# -*- coding: utf-8 -*-

# Define your item pipelines here
#
# Don't forget to add your pipeline to the ITEM_PIPELINES setting
# See: https://docs.scrapy.org/en/latest/topics/item-pipeline.html
import pymysql

class DzdpPipeline(object):

    def __init__(self):
        self.connection = pymysql.connect(host='127.0.0.1', port=3306, user='root', password='', database='dzdp', charset='utf8mb4')
        self.cursor = self.connection.cursor()
        self._sql = None

    def process_item(self, item, spider):
        self.cursor.execute(self.sql, (item['_id'], item['title'], item['score'], item['comments'], item['price']))
        self.connection.commit()
        return item

    @property
    def sql(self):
        if not self._sql:
            self._sql = """
            insert into shop_list(ID, title, score, comments, price) values(%s, %s, %s, %s, %s)
            """
        return self._sql