# -*- coding: utf-8 -*-

# Define your item pipelines here
#
# Don't forget to add your pipeline to the ITEM_PIPELINES setting
# See: https://docs.scrapy.org/en/latest/topics/item-pipeline.html
from scrapy.exporters import JsonLinesItemExporter
from fang.items import NewHouseItem, ESFItem

class FangPipeline(object):
    def __init__(self):
        self.newhouse_fp = open('newhouse.json', 'wb')
        self.esf_fp = open('esf.json', 'wb')
        self.exporter_newhouse = JsonLinesItemExporter(self.newhouse_fp, ensure_ascii=False)
        self.exporter_esf = JsonLinesItemExporter(self.esf_fp, ensure_ascii=False)

    def process_item(self, item, spider):
        if isinstance(item, NewHouseItem):
            self.exporter_newhouse.export_item(item)
        elif isinstance(item, ESFItem):
            self.exporter_esf.export_item(item)
        return item

    def close_spider(self, spider):
        self.newhouse_fp.close()
        self.esf_fp.close()