## 中国注会、审计师、事务所信息爬虫
### 简介

信息来自[中国注册会计师行业信息管理系统](http://cmispub.cicpa.org.cn/cicpa2_web/goto/nomsg/DNA_XH/default.shtml)，由 `Python` 的 `Scrapy` 框架编写。

#### Requirements

1. Python3
2. MongoDB
3. Scrapy
4. re module
4. pymongo module

爬取的信息为 `json` 格式，存储在 `MongoDB` 中，默认存储在 `Auditors` 的4个数据库中：

1. audit_firm
2. nwp_info
3. cpa_info
4. cpa_profile

可以在 `Pipeline.py` 中自定义存储方式和存储位置。

#### 数据样式

##### audit_firm：

> {
'主任会计师': '耿云明',
 '从业人员人数': '21',
 '从业人员人数（含分所）': '21',
 '会计师事务所名称': '北京中之光会计师事务所有限责任公司',
 '传真': '010-83131728',
 '出资额或注册资本（万元）': '100.0',
 '分所数量': '0',
 '办公地址': '北京市海淀区北四环西路67号中关村创业大厦904室',
 '加入国际网络': '无',
 '博士研究生人数': '0',
 '参与公益活动': '无',
 '合伙人或股东人数': '4',
 '境外分支机构': '无',
 '处罚/惩戒信息(披露时限:自2017年至今)': '无',
 '大专及以下人数': '5',
 '大于70岁人数': '5',
 '小于等于40岁人数': '1',
 '小于等于60岁且大于40岁人数': '6',
 '小于等于70岁且大于60岁人数': '2',
 '批准设立文件号': '京财协（1996）1989号',
 '批准设立时间': '1996-11-18',
 '批准设立机关': '北京市财政局',
 '是否具有内部培训资格': '否',
 '本科人数': '8',
 '法定代表人（或执行合伙人）': '耿云明',
 '注册会计师人数': '14',
 '注册会计师人数（含分所）': '14',
 '电子邮箱': '635114023@qq.com',
 '硕士研究生人数': '1',
 '组织形式（有限/合伙）': '有限责任',
 '继续教育完成率（上一年度）': '85.71%',
 '网址': '无',
 '联系人': '耿云明',
 '联系电话': '13910222743',
 '被检查信息': '请点击',
 '证书编号': '11000001',
 '通讯地址': '北京市海淀区北四环西路67号中关村创业大厦904室',
 '邮政编码': '100053'
}

##### nwp_info：

>{
 '姓名': '郑天一',
 '序号': '20',
 '性别': '女',
 '所在事务所': '北京中之光会计师事务所有限责任公司（从业人员）',
 '是否党员': '否',
 '是否参加社保': '否',
 '是否签合同': '是',
 '进所时间': '2007-01-01'
}

##### cpa_info：

> {
 '人员编号': '110000342374',
 '全科合格证号（或者考核批准文号）': '鲁财会字〔1993〕第79号',
 '出生日期': '1948-01-07',
 '姓名': '刘家友',
 '序号': '4',
 '性别': '男',
 '所在事务所': '北京中仁信会计师事务所（注册会计师）'
}

##### cpa_profile：

> {
 '全科合格年份': '1997',
 '全科合格证书号': 'A97070060',
 '参加公益活动': '无',
 '处罚/惩戒信息': '无',
 '姓名': '李朝霞',
 '学位': '其它',
 '学历': '硕士',
 '性别': '女',
 '所内职务': '无',
 '所在事务所': '北京驰创会计师事务所有限责任公司',
 '所学专业': '矿产普查勘察',
 '批准注册文件号': '京会协（2000）093号',
 '批准注册时间': '2000-12-15',
 '是否党员': '否',
 '是否合伙人（股东）': '是',
 '本年度已完成学时': '0',
 '本年度应完成学时': '40',
 '毕业学校': '中国地质大学',
 '注册会计师证书编号': '110001332698',
 '资格取得方式（考试/考核）': '考试'
}

### 使用方法

使用命令行工具 cd 到项目目录，输入：

> scrapy crawl cpa

也可以输出log到指定文件：

> scrapy crawl cpa -s LOG_FILE=cpa_crawler.log

如果不想通过命令行工具执行地话，可以直接运行 `start.py`，也可以在 `start.py` 中添加 `-s LOG_FILE=cpa_crawler.log` 来输出log到指定文件。

默认的下载延迟设置为`1s`，由于爬取的网页很多，所以比较慢，如果时间比较赶的话，可以视情况调低下载延迟，或者直接取消。在 `settings.py` 找到下面这行：

> DOWNLOAD_DELAY = 1

直接注释掉。

注：
1. `item` 的 `fields` 在实际爬取的时候动态生成，所以写在了 `spider` 中，`item.py` 只是继承了几个子类。
2. 我写这个爬虫的时候，会计师事务所列表一共只有 `631` 页，如果页数有变化的话，请找到 `cpa.py` 的 `38` 行：

> for page in range(1, 632):

把 `632` 修改成当前的总页数 `+1`, 总页数在可以在 `“会计师事务所信息查询”` 中获取。